
#version 120

uniform float t;
uniform sampler2D input;

vec4 rgbtohsl(vec4 rgb)
{
	vec4 hsl;
	float ma = max(max(rgb.x, rgb.y), rgb.z);
	float mi = min(min(rgb.x, rgb.y), rgb.z);
	float ma_d = ma - mi;
	float ma_s = ma + mi;
	
	hsl.z = ma_s / 2;
	hsl.y = ma_d / (-abs(ma_s - 1) + 1);
	
	float rd = (((ma - rgb.x) / 6) + (ma_d / 2)) / ma_d;
	float gd = (((ma - rgb.y) / 6) + (ma_d / 2)) / ma_d;
	float bd = (((ma - rgb.z) / 6) + (ma_d / 2)) / ma_d;
	
	hsl.x = bd - gd;
	//hsl.x = mix(hsl.x, 0.3333 + rd - bd, clamp((rgb.y - ma) * (1 / ma), 0, 1));
	//hsl.x = mix(hsl.x, 0.6666 + gd - rd, clamp((rgb.z - ma) * (1 / ma), 0, 1));
	if (rgb.y == ma)
		hsl.x = 0.3333 + rd - bd;	
	if (rgb.z == ma)
		hsl.x = 0.6666 + gd - rd;
	
	if (hsl.x < 0) 
		hsl.x += 1;
	if (hsl.x > 1) 
		hsl.x -= 1;
		
	hsl.w = rgb.w;
		
	return hsl;
}

vec4 hsltorgb(vec4 hsl)
{
	vec4 rgb;
	float a = hsl.y * (1 - abs(hsl.z * 2 - 1));
	float b = hsl.z - a / 2;
	rgb.x = clamp(abs((hsl.x - 0.5) * 6) - 1, 0, 1) * a + b;
	rgb.y = clamp(-abs((hsl.x - 0.33333) * 6) + 2, 0, 1) * a + b;
	rgb.z = clamp(-abs((hsl.x - 0.66666) * 6) + 2, 0, 1) * a + b;
	rgb.w = hsl.w;
	
	return rgb;
}

void main()
{
	//gl_FragColor = mix(vec4(0,0,0,1), vec4(1,1,1,1), gl_TexCoord[0].t);
	vec2 c = gl_TexCoord[0].st - 0.5;
	c.t *= 0.5625; // correct aspect to 16/9
	vec4 burn = mix(vec4(1,1,1,1), vec4(0,0,0,1), sqrt(c.x * c.x + c.y * c.y) * 1.1);
	vec4 color = mix(vec4(0.674509804, 0.360784314, 0.17254902, 1), vec4(0.909803922, 0.490196078, 0.447058824, 1), gl_TexCoord[0].t);
	//color = texture2D(input, gl_TexCoord[0].st);
	vec4 color_hsl = rgbtohsl(color);
	vec4 input_c = texture2D(input, gl_TexCoord[0].st);
	vec4 colored = mix(input_c, hsltorgb(vec4(color_hsl.x, color_hsl.y, rgbtohsl(input_c).z, 1)), 0.443);
	gl_FragColor = mix(colored, 1 - (1 - colored) / (burn + 0.01), 0.431); // burn 43%
}
